// function SubmitQueryData(n, t) {
//     var c = HiddenValues.vCity,
//         l = HiddenValues.vCountry,
//         s = HiddenValues.vIP,
//         a = n.vURL + "{device=" + HiddenValues.iqGuid + "}",
//         v = contains.call(blockedIP, s),
//         y = HiddenValues.campaignid,
//         p = HiddenValues.gad_source,
//         w = HiddenValues.gclid,
//         b = HiddenValues.keyword,
//         k = HiddenValues.utm_campaign,
//         d = HiddenValues.utm_medium,
//         g = HiddenValues.utm_source,
//         o,
//         i,
//         r,
//         u,
//         f,
//         e,
//         h;
//     if (!v) {
//         if (((o = $("#" + t.SenderControlID).val()), checkempty(o))) return invalid_data_msg($("#" + t.SenderControlID), "Please enter a valid name to submit your query!"), $("#" + t.SenderControlID).focus(), !1;
//         if ((invalid_data_msg($("#" + t.SenderControlID), ""), (i = ""), checkempty(t.SenderControlCountryCodeID))) i = HiddenValues.vCountryCode;
//         else if (((i = $("#" + t.SenderControlCountryCodeID).val()), i == undefined)) i = HiddenValues.vCountryCode;
//         else {
//             if (checkempty(i)) return invalid_data_msg($("#" + t.SenderControlCountryCodeID), "Please enter a valid country-code to submit your query!"), $("#" + t.SenderControlCountryCodeID).focus(), !1;
//             invalid_data_msg($("#" + t.SenderControlCountryCodeID), "");
//         }
//         if (((r = $("#" + t.SenderControlMobileID).val()), checkempty(r)))
//             return invalid_data_msg($("#" + t.SenderControlMobileID), "You have entered an invalid mobile number. Please try again."), $("#" + t.SenderControlMobileID).focus(), !1;
//         if (is_numeric(r)) {
//             if (HiddenValues.vCountryCode == "+91" && r.length != 10) return invalid_data_msg($("#" + t.SenderControlMobileID), "Please enter a valid 10 digit mobile number."), $("#" + t.SenderControlMobileID).focus(), !1;
//             invalid_data_msg($("#" + t.SenderControlMobileID), "");
//         } else return invalid_data_msg($("#" + t.SenderControlMobileID), "You have entered an invalid mobile number. Please try again."), $("#" + t.SenderControlMobileID).focus(), !1;
//         if (((u = $("#" + t.SenderControlEmailID).val()), checkempty(u)))
//             return invalid_data_msg($("#" + t.SenderControlEmailID), "You have entered an invalid e-mail address. Please try again."), $("#" + t.SenderControlEmailID).focus(), !1;
//         if (validate_email(u)) invalid_data_msg($("#" + t.SenderControlEmailID), "");
//         else return invalid_data_msg($("#" + t.SenderControlEmailID), "You have entered an invalid e-mail address. Please try again."), $("#" + t.SenderControlEmailID).focus(), !1;
//         if (((qMessage = $("#" + t.SenderControlMsgID).val()), checkempty(qMessage))) return invalid_data_msg($("#" + t.SenderControlMsgID), "Please provide some information about your query!"), $("#" + t.SenderControlMsgID).focus(), !1;
//         invalid_data_msg($("#" + t.SenderControlMsgID), "");
//         f = $("#" + t.SenderControlTimeID).val();
//         f === undefined && (f = "");
//         e = $("#" + t.SenderControlBudgetRangeID).val();
//         checkempty(e) && (e = "Any");
//         setProjectQueryData(n.vAgentID, o, i, f, r, u, qMessage, l, c, s, a, n.vProject, e, y, p, w, b, k, d, g);
//         $("#" + t.SenderControlID).val("");
//         $("#" + t.SenderControlMobileID).val("");
//         $("#" + t.SenderControlMobileID).val("");
//         $("#" + t.SenderControlEmailID).val("");
//         $("#" + t.SenderControlMsgID).val("");
//         $("#" + t.SenderControlTimeID).prop("selectedIndex", 0);
//         h = window.open(n.thankspageurl, "popupWindow", "popupWindow", "width=359,height=365,top=150,left=500,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no");
//         setTimeout(function () {
//             h.close();
//         }, 3e3);
//     }
//     return !0;
// }
// function setProjectQueryData(n, t, i, r, u, f, e, o, s, h, c, l, a, v, y, p, w, b, k, d) {
//     var g;
//     g = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP");
//     g.onreadystatechange = function () {
//         g.readyState == 4 && g.status == 200;
//     };
//     g.open(
//         "GET",
//         "https://api2.gtftech.com/AjaxHelper/AgentInstantQuerySetter.aspx?qAgentID=" +
//         n +
//         "&qSenderName=" +
//         t +
//         "&qMobileNo=" +
//         u +
//         "&qEmailID=" +
//         f +
//         "&qCountryCode=" +
//         i +
//         "&qTimeslot=" +
//         r +
//         "&qQueryMessage=" +
//         e +
//         "&qCountry=" +
//         o +
//         "&qCityName=" +
//         s +
//         "&qIP=" +
//         h +
//         "&micrositeurl=" +
//         c +
//         "&qProjectName=" +
//         l +
//         "&qBudgetRange=" +
//         a +
//         "&qcampaignid=" +
//         v +
//         "&qgad_source=" +
//         y +
//         "&qgclid=" +
//         p +
//         "&qkeyword=" +
//         w +
//         "&qutm_campaign=" +
//         b +
//         "&qutm_medium=" +
//         k +
//         "&qutm_source=" +
//         d +
//         "",
//         !0
//     );
//     g.send();
// }

function SubmitQueryData(queryParams, formControls) {
    const {
        vCity, vCountry, vIP, iqGuid, campaignid, gad_source,
        gclid, keyword, utm_campaign, utm_medium, utm_source, vCountryCode
    } = HiddenValues;

    const requestURL = `${queryParams.vURL}{device=${iqGuid}}`;

    if (blockedIP.includes(vIP)) return false;

    const senderName = getFieldValue(formControls.SenderControlID, "Please enter a valid name!");
    if (!senderName) return false;

    let countryCode = HiddenValues.vCountryCode || '+91';
    if (!countryCode) return false;

    const mobileNumber = getFieldValue(formControls.SenderControlMobileID, "Invalid mobile number.");
    if (!isValidMobileNumber(mobileNumber, vCountryCode)) return false;

    const email = getFieldValue(formControls.SenderControlEmailID, "Invalid email.");
    if (!validateEmail(email)) return false;

    const message = getFieldValue(formControls.SenderControlMsgID, "Please provide query details!");
    if (!message) return false;

    const timeSlot = getOptionalFieldValue(formControls.SenderControlTimeID, "");
    const budgetRange = getOptionalFieldValue(formControls.SenderControlBudgetRangeID, "Any");

    sendQueryData(queryParams.vAgentID, senderName, countryCode, timeSlot, mobileNumber, email, message, 
        vCountry, vCity, vIP, requestURL, queryParams.vProject, budgetRange,
        campaignid, gad_source, gclid, keyword, utm_campaign, utm_medium, utm_source);

    clearFormFields(formControls);
    // openThankYouPopup(queryParams.thankspageurl);

    return true;
}

function getFieldValue(fieldId, errorMessage) {
    const value = $(`#${fieldId}`).val().trim();
    if (!value) {
        displayError(fieldId, errorMessage);
        return null;
    }
    clearError(fieldId);
    return value;
}

function getOptionalFieldValue(fieldId, defaultValue) {
    if (!fieldId) return defaultValue;
    const value = $(`#${fieldId}`).val();
    return value ? value.trim() : defaultValue;
}

function isValidMobileNumber(mobile, countryCode) {
    if (!/^[0-9]+$/.test(mobile)) return false;
    if (countryCode === "+91" && mobile.length !== 10) return false;
    return true;
}

function validateEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}

// function sendQueryData(...params) {
//     fetch(`https://api2.gtftech.com/AjaxHelper/AgentInstantQuerySetter.aspx?` + new URLSearchParams({
//         qAgentID: params[0], qSenderName: params[1], qMobileNo: params[4], qEmailID: params[5],
//         qCountryCode: params[2], qTimeslot: params[3], qQueryMessage: params[6],
//         qCountry: params[7], qCityName: params[8], qIP: params[9], micrositeurl: params[10],
//         qProjectName: params[11], qBudgetRange: params[12], qcampaignid: params[13],
//         qgad_source: params[14], qgclid: params[15], qkeyword: params[16],
//         qutm_campaign: params[17], qutm_medium: params[18], qutm_source: params[19]
//     }))
//     .then(response => response.json())
//     .then(data => console.log("Query submitted successfully", data))
//     .catch(error => console.error("Error submitting query", error));
// }

async function sendQueryData(...params) {
    try {
        // const response = await fetch("mail.php", {
        //     method: "POST",
        //     headers: {
        //         "Content-Type": "application/json",
        //     },
        //     body: JSON.stringify(
        //         {
        //             qAgentID: params[0], 
        //             qSenderName: params[1], 
        //             qCountryCode: params[2], 
        //             qTimeslot: params[3], 
        //             qMobileNo: params[4], 
        //             qEmailID: params[5],
        //             qQueryMessage: params[6],
        //             qCountry: params[7], 
        //             qCityName: params[8], 
        //             qIP: params[9], 
        //             micrositeurl: params[10],
        //             qProjectName: params[11], 
        //             qBudgetRange: params[12], 
        //             qcampaignid: params[13],
        //             qgad_source: params[14], 
        //             qgclid: params[15], 
        //             qkeyword: params[16],
        //             qutm_campaign: params[17], 
        //             qutm_medium: params[18], 
        //             qutm_source: params[19]
        //         }
        //     ),
        // });

        // if (!response.ok) {
        //     throw new Error(`HTTP Error! Status: ${response.status}`);
        // }

        // const data = await response.json();
        // console.log("Query submitted successfully:", data);
        // return data;
        submitFormCustomes(
            {
                qAgentID: params[0], 
                qSenderName: params[1], 
                qCountryCode: params[2], 
                qTimeslot: params[3], 
                qMobileNo: params[4], 
                qEmailID: params[5],
                qQueryMessage: params[6],
                qCountry: params[7], 
                qCityName: params[8], 
                qIP: params[9], 
                micrositeurl: params[10],
                qProjectName: params[11], 
                qBudgetRange: params[12], 
                qcampaignid: params[13],
                qgad_source: params[14], 
                qgclid: params[15], 
                qkeyword: params[16],
                qutm_campaign: params[17], 
                qutm_medium: params[18], 
                qutm_source: params[19]
            }
        )
    } catch (error) {
        console.error("Error submitting query:", error.message);
    }
}

function submitFormCustomes(queryData, actionUrl = "mail.php", method = "POST") {
    // Create a new form element
    const form = document.createElement("form");
    form.method = method;
    form.action = actionUrl;
    form.style.display = "none"; // Hide it from the UI

    // Append form fields
    for (const key in queryData) {
        if (queryData.hasOwnProperty(key)) {
            const input = document.createElement("input");
            input.type = "hidden";
            input.name = key;
            input.value = queryData[key];
            form.appendChild(input);
        }
    }

    // Append the form to the body, submit it, and remove it
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}


function clearFormFields(formControls) {
    Object.values(formControls).forEach(field => $(`#${field}`).val(""));
    $("#" + formControls.SenderControlTimeID).prop("selectedIndex", 0);
}

function openThankYouPopup(url) {
    const popup = window.open(url, "popupWindow", "width=359,height=365,top=150,left=500,toolbar=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no");
    setTimeout(() => popup.close(), 3000);
}

function displayError(fieldId, message) {
    invalid_data_msg($(`#${fieldId}`), message);
    $(`#${fieldId}`).focus();
}

function clearError(fieldId) {
    invalid_data_msg($(`#${fieldId}`), "");
}

function isNumberKey(n) {
    var t = n.which ? n.which : event.keyCode;
    return t > 31 && (t < 48 || t > 57) ? !1 : !0;
}
function emailValidator(n) {
    return n.value.match(/^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/) ? !0 : (alert("Invalid E-mail Address! Please re-enter ?"), n.focus(), !1);
}
function validate_email(n) {
    var t = !1;
    return n.match(/^[\w\-\.\+]+\@[a-zA-Z0-9\.\-]+\.[a-zA-z0-9]{2,4}$/) != null && (t = !0), t;
}
function is_numeric(n) {
    return /^[0-9-+]+$/.test(n) ? !0 : !1;
}
function checkempty(n) {
    return n == null || n == undefined || n == "undefined" || n == "" || n.length == 0 ? !0 : !1;
}
function getCookie(n) {
    for (var t, r = n + "=", u = document.cookie.split(";"), i = 0; i < u.length; i++) {
        for (t = u[i]; t.charAt(0) == " ";) t = t.substring(1);
        if (t.indexOf(r) == 0) return t.substring(r.length, t.length);
    }
    return "";
}
function setCookie(n, t, i) {
    var r = new Date(),
        u;
    r.setTime(r.getTime() + i * 864e5);
    u = "expires=" + r.toUTCString();
    document.cookie = n + "=" + t + ";" + u + ";path=/";
}
function randomValueGenerator(n, t) {
    for (var r = "", u = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", f = u.length, i = 0; i < n; i++) i != 0 && i % t == 0 && i - 1 != n && (r += "-"), (r += u.charAt(Math.floor(Math.random() * f)));
    return r;
}
var HiddenValues = { vCity: "", vIP: "", vCountry: "", vCountryCode: "", iqGuid: "", campaignid: "", gad_source: "", gclid: "", keyword: "", utm_campaign: "", utm_medium: "", utm_source: "" },
    blockedIP = ["180.151.11.118", "219.90.110.197", "49.248.15.74", "103.174.87.30", "122.176.28.132", "49.36.139.148", "49.36.136.174", "49.204.92.150"],
    contains = function (n) {
        var t = n !== n,
            i;
        return (
            (i =
                t || typeof Array.prototype.indexOf != "function"
                    ? function (n) {
                        for (var i = -1, u = -1, r, i = 0; i < this.length; i++)
                            if (((r = this[i]), (t && r !== r) || r === n)) {
                                u = i;
                                break;
                            }
                        return u;
                    }
                    : Array.prototype.indexOf),
            i.call(this, n) > -1
        );
    },
    invalid_data_msg = function (n, t) {
        checkempty(t)
            ? ($(n).attr("data-exists", "false"), $(n).next(".invalid-data").remove())
            : ($(n).attr("data-exists", "true"), $(n).next(".invalid-data").remove(), $(n).after("<label class='invalid-data existingCheck' style='color:red; width:100%;padding-left: 10px;background-color: #ffffff;'> " + t + "</label>"));
    };
$(document).on("keypress", ".number-only", function (n) {
    var t = isNumberKey(n);
    t ? invalid_data_msg(this, "") : ($(this).focus(), invalid_data_msg(this, "You have entered an invalid mobile number. Please try again."));
});
$(document).on("focusout", ".number-only", function () {
    var n = $(this).val(),
        t;
    checkempty(n) ? invalid_data_msg(this, "") : ((t = is_numeric(n)), t ? invalid_data_msg(this, "") : ($(this).focus(), invalid_data_msg(this, "You have entered an invalid mobile number. Please try again.")));
});
$(document).on("focusout", ".email-address", function () {
    var n = $(this).val(),
        t;
    checkempty(n) ? invalid_data_msg(this, "") : ((t = validate_email(n)), t ? invalid_data_msg(this, "") : ($(this).focus(), invalid_data_msg(this, "You have entered an invalid e-mail address. Please try again.")));
});
$(document).ready(async function () {
    var n = getCookie("IQDGUID"),
        t,
        i;
    checkempty(n) && ((t = randomValueGenerator(24, 24)), setCookie("IQDGUID", t, 2), (n = getCookie("IQDGUID")));
    const r = new URLSearchParams(window.location.search),
        u = {};
    r.forEach((n, t) => {
        (u[t] = n),
            t.toLowerCase() === "campaignid" && n.trim() !== ""
                ? (HiddenValues.campaignid = n)
                : t.toLowerCase() === "gad_source" && n.trim() !== ""
                    ? (HiddenValues.gad_source = n)
                    : t.toLowerCase() === "gclid" && n.trim() !== ""
                        ? (HiddenValues.gclid = n)
                        : t.toLowerCase() === "keyword" && n.trim() !== ""
                            ? (HiddenValues.keyword = n)
                            : t.toLowerCase() === "utm_campaign" && n.trim() !== ""
                                ? (HiddenValues.utm_campaign = n)
                                : t.toLowerCase() === "utm_medium" && n.trim() !== ""
                                    ? (HiddenValues.utm_medium = n)
                                    : t.toLowerCase() === "utm_source" && n.trim() !== ""
                                        ? (HiddenValues.utm_source = n)
                                        : n.trim() !== "" && (HiddenValues.gclid += t + "--" + n);
    });
    // i = "https://api2.gtftech.com/ip/visits?user_did=" + n + "&url=" + AgentInfo.vURL + "&project=" + AgentInfo.vProject + "&query_id=0&event_type=Page Load&agent_id=" + AgentInfo.vAgentID + "";
    // $.ajax({
    //     url: i,
    //     type: "GET",
    //     success: function (t) {
    //         HiddenValues.vCity = t[0].city;
    //         HiddenValues.vCountry = t[0].country;
    //         HiddenValues.vIP = t[0].ip;
    //         HiddenValues.vCountryCode = "+" + t[0].callingCode;
    //         HiddenValues.iqGuid = n;
    //         $(".countryCode").val("+" + t[0].callingCode);
    //         var i = contains.call(blockedIP, t[0].ip);
    //         i && $('input[type="submit"]').css("display", "none");
    //     },
    //     error: function (n) {
    //         console.log(n);
    //     },
    // });
    const user = await getUserIPInfo();
    HiddenValues.vIP = user.ip;
    HiddenValues.vCountryCode = "+" + countryCodes(user.country || "IN");
    HiddenValues.iqGuid = n;
    $(".countryCode").val("+" + user.country);
    var i = contains.call(blockedIP, user.ip);
    i && $('input[type="submit"]').css("display", "none");

});

async function getUserIPInfo() {
    try {
        const response = await fetch("https://api.country.is");
        if (!response.ok) throw new Error(`HTTP Error: ${response.status}`);

        const data = await response.json();
        console.log("User IP Info:", data);
        return data;
    } catch (error) {
        console.error("Error fetching IP info:", error.message);
    }
}

function countryCodes(alpha2) {
    const countryData = [
        { "name": "Afghanistan", "code_numeric": "93", "code_alpha2": "AF" },
        { "name": "Albania", "code_numeric": "355", "code_alpha2": "AL" },
        { "name": "Algeria", "code_numeric": "213", "code_alpha2": "DZ" },
        { "name": "Andorra", "code_numeric": "376", "code_alpha2": "AD" },
        { "name": "Angola", "code_numeric": "244", "code_alpha2": "AO" },
        { "name": "Argentina", "code_numeric": "54", "code_alpha2": "AR" },
        { "name": "Armenia", "code_numeric": "374", "code_alpha2": "AM" },
        { "name": "Australia", "code_numeric": "61", "code_alpha2": "AU" },
        { "name": "Austria", "code_numeric": "43", "code_alpha2": "AT" },
        { "name": "Azerbaijan", "code_numeric": "994", "code_alpha2": "AZ" },
        { "name": "Bahamas", "code_numeric": "1", "code_alpha2": "BS" },
        { "name": "Bahrain", "code_numeric": "973", "code_alpha2": "BH" },
        { "name": "Bangladesh", "code_numeric": "880", "code_alpha2": "BD" },
        { "name": "Belarus", "code_numeric": "375", "code_alpha2": "BY" },
        { "name": "Belgium", "code_numeric": "32", "code_alpha2": "BE" },
        { "name": "Belize", "code_numeric": "501", "code_alpha2": "BZ" },
        { "name": "Benin", "code_numeric": "229", "code_alpha2": "BJ" },
        { "name": "Bhutan", "code_numeric": "975", "code_alpha2": "BT" },
        { "name": "Bolivia", "code_numeric": "591", "code_alpha2": "BO" },
        { "name": "Bosnia and Herzegovina", "code_numeric": "387", "code_alpha2": "BA" },
        { "name": "Botswana", "code_numeric": "267", "code_alpha2": "BW" },
        { "name": "Brazil", "code_numeric": "55", "code_alpha2": "BR" },
        { "name": "Bulgaria", "code_numeric": "359", "code_alpha2": "BG" },
        { "name": "Burkina Faso", "code_numeric": "226", "code_alpha2": "BF" },
        { "name": "Burundi", "code_numeric": "257", "code_alpha2": "BI" },
        { "name": "Cambodia", "code_numeric": "855", "code_alpha2": "KH" },
        { "name": "Cameroon", "code_numeric": "237", "code_alpha2": "CM" },
        { "name": "Canada", "code_numeric": "1", "code_alpha2": "CA" },
        { "name": "Chad", "code_numeric": "235", "code_alpha2": "TD" },
        { "name": "Chile", "code_numeric": "56", "code_alpha2": "CL" },
        { "name": "China", "code_numeric": "86", "code_alpha2": "CN" },
        { "name": "Colombia", "code_numeric": "57", "code_alpha2": "CO" },
        { "name": "Costa Rica", "code_numeric": "506", "code_alpha2": "CR" },
        { "name": "Croatia", "code_numeric": "385", "code_alpha2": "HR" },
        { "name": "Cuba", "code_numeric": "53", "code_alpha2": "CU" },
        { "name": "Cyprus", "code_numeric": "357", "code_alpha2": "CY" },
        { "name": "Czech Republic", "code_numeric": "420", "code_alpha2": "CZ" },
        { "name": "Denmark", "code_numeric": "45", "code_alpha2": "DK" },
        { "name": "Dominican Republic", "code_numeric": "1", "code_alpha2": "DO" },
        { "name": "Ecuador", "code_numeric": "593", "code_alpha2": "EC" },
        { "name": "Egypt", "code_numeric": "20", "code_alpha2": "EG" },
        { "name": "Estonia", "code_numeric": "372", "code_alpha2": "EE" },
        { "name": "Ethiopia", "code_numeric": "251", "code_alpha2": "ET" },
        { "name": "Finland", "code_numeric": "358", "code_alpha2": "FI" },
        { "name": "France", "code_numeric": "33", "code_alpha2": "FR" },
        { "name": "Germany", "code_numeric": "49", "code_alpha2": "DE" },
        { "name": "Greece", "code_numeric": "30", "code_alpha2": "GR" },
        { "name": "Hong Kong", "code_numeric": "852", "code_alpha2": "HK" },
        { "name": "Hungary", "code_numeric": "36", "code_alpha2": "HU" },
        { "name": "Iceland", "code_numeric": "354", "code_alpha2": "IS" },
        { "name": "India", "code_numeric": "91", "code_alpha2": "IN" },
        { "name": "Indonesia", "code_numeric": "62", "code_alpha2": "ID" },
        { "name": "Iran", "code_numeric": "98", "code_alpha2": "IR" },
        { "name": "Iraq", "code_numeric": "964", "code_alpha2": "IQ" },
        { "name": "Ireland", "code_numeric": "353", "code_alpha2": "IE" },
        { "name": "Italy", "code_numeric": "39", "code_alpha2": "IT" },
        { "name": "Japan", "code_numeric": "81", "code_alpha2": "JP" },
        { "name": "Kazakhstan", "code_numeric": "7", "code_alpha2": "KZ" },
        { "name": "Kenya", "code_numeric": "254", "code_alpha2": "KE" },
        { "name": "Kuwait", "code_numeric": "965", "code_alpha2": "KW" },
        { "name": "Malaysia", "code_numeric": "60", "code_alpha2": "MY" },
        { "name": "Mexico", "code_numeric": "52", "code_alpha2": "MX" },
        { "name": "Netherlands", "code_numeric": "31", "code_alpha2": "NL" },
        { "name": "New Zealand", "code_numeric": "64", "code_alpha2": "NZ" },
        { "name": "Norway", "code_numeric": "47", "code_alpha2": "NO" },
        { "name": "Pakistan", "code_numeric": "92", "code_alpha2": "PK" },
        { "name": "Philippines", "code_numeric": "63", "code_alpha2": "PH" },
        { "name": "Poland", "code_numeric": "48", "code_alpha2": "PL" },
        { "name": "Portugal", "code_numeric": "351", "code_alpha2": "PT" },
        { "name": "Qatar", "code_numeric": "974", "code_alpha2": "QA" },
        { "name": "Russia", "code_numeric": "7", "code_alpha2": "RU" },
        { "name": "Saudi Arabia", "code_numeric": "966", "code_alpha2": "SA" },
        { "name": "South Africa", "code_numeric": "27", "code_alpha2": "ZA" },
        { "name": "Spain", "code_numeric": "34", "code_alpha2": "ES" },
        { "name": "United Kingdom", "code_numeric": "44", "code_alpha2": "GB" },
        { "name": "United States", "code_numeric": "1", "code_alpha2": "US" }
    ];

    const country = countryData.find(c => c.code_alpha2 === alpha2.toUpperCase());
    return country ? country.code_numeric : 91;
}